﻿using System;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Ink;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;

using System.Collections.ObjectModel;
using System.Collections.Generic;

namespace iXTankenSimple
{
    public class MainViewModel:ViewModelBase
    {
        private ObservableCollection<TankVorgang> _DataSource = null;

        public ObservableCollection<TankVorgang> DataSource 
        { 
            get 
            { 
                if (_DataSource == null) 
                { 
                    _DataSource = new ObservableCollection<TankVorgang>();
                } 
                return _DataSource; 
            } 
            private set 
            { 
                if (_DataSource != value) 
                { 
                    _DataSource = value; 
                    this.RaisePropertyChanged("DataSource"); 
                } 
            } 
        }

        private ICommand _LoadDataCommand;
 
        public ICommand LoadDataCommand 
        { 
            get 
            { 
                return _LoadDataCommand; 
            } 
        }

        public void Initialize()
        {
            LoadDataAction(null);
        }

        private void LoadDataAction(object p) 
        { 
            IEnumerable<TankVorgang> tankVorgangList = this.GetService<ITankvorgangModelService>().GetTankVorgangList(); 
            this.DataSource = new ObservableCollection<TankVorgang>(tankVorgangList); 
        }

        private ICommand _AddNewTankVorgang;

        private void AddNewTankVorgang(object p)
        { 
            this.GetService<INavigationService>().NavigateToAddNewTankVorgang(); 
        }

        public ICommand AddNewTankVorgangCommand 
        { 
            get 
            { 
                return _AddNewTankVorgang; 
            } 
        }

        public MainViewModel()
        {        
            _LoadDataCommand = new DelegateCommand(this.LoadDataAction);
            _AddNewTankVorgang = new DelegateCommand(this.AddNewTankVorgang);
            LoadDataAction(null);
        }
    }
}
